<?php
	/**
	 * Load everything else
	 *
	 * @package aCMS
	 */
	$INITTIME = microtime(true);
	/**
	 * The minimum level at which report logging messages should be displayed
	 * before the configuration system is loaded
	 * 
	 * After the configuration system is loaded all values can be fine-tuned
	 * with the report.* config configuration settings and this constant is
	 * ignored.
	 * 
	 * Please note that there will be no logging to the logfile before the
	 * configuration system isn't initialized.
	 */
	define("REPORT_PRECONFIG_MINIMUM_DISPLAY_LEVEL", "warning");
	
	/**
	 * Display a traceback for all logging messages shown prior to the
	 * configuration system load
	 */
	define("REPORT_PRECONFIG_TRACEBACK", true);
	
	// Load basic configuration
	require_once('config.dat.php');
	// Setup environment
	require_once("{$DATADIR}/initialize.inc.php");
	require_once("{$DATADIR}/stuff.inc.php");
	
	// Load and display content:
	try {
		// Populate configuration data
		require_once("{$DATADIR}/classes/Configuration.class.php");
		$CONFIGURATION = new Configuration();
		
		// Load page
		require_once("{$DATADIR}/request.inc.php");
		$request = new Request(array_merge($_POST, $_GET));
		$request->display();
	} catch(AOFError $error) {
		$error->send_headers();
		$error->display_content();
	}
