<?php
	/**
	 * Where are the data-files of aCMS are stored?
	 */
	$DATADIR = 'CMS/aCMS-base';
	
	/**
	 * What configuration type should be used?
	 * 
	 * Possible Values:
	 * 	- ini:        (file)     Use the .INI- or configuration-file format
	 *  - json:       (file)     Use the JavaScript Object Notation format
	 * 	- mysql:      (database) Use the MySQL server database
	 *  - postgresql: (database) Use the PostGreSQL server database 
	 *  - sqlite:     (database) Use the SQLite file database format
	 */
	$CONFIG_TYPE = 'postgresql';
	
	/**
	 * What file should be used?
	 * 
	 * Values:
	 * 	- [filepath]: The path of a file
	 */
	$CONFIG_FILEPATH = dirname(__FILE__) . '/' . "config.ini";
	
	/**
	 * Which server should be connected to?
	 * 
	 * Values:
	 * 	- localhost: Connect to the current server
	 * 	- [host]:    The name of the server to connect to
	 */
	$CONFIG_HOSTNAME = 'localhost';
	
	/**
	 * Which user name should be used to access the data?
	 * 
	 * Values:
	 * 	- [user]: The name of the user which accesses the data
	 */
	$CONFIG_USERNAME = '';
	
	/**
	 * Which password should be used to access the data?
	 * 
	 * Values:
	 * 	- [password]: The password of the user which accesses the data
	 */
	$CONFIG_PASSWORD = '';
	
	/**
	 * Which database should be used?
	 * 
	 * Values:
	 * 	- [database]: The name of the database which contains the data
	 */
	$CONFIG_DATABASE = '';
		
	/**
	 * Which database table should be used for configuration?
	 * 
	 * Values:
	 * 	- [table]:	The name of a table to use
	 */
	$CONFIG_TABLE = 'aCMS-config';
