<?php
	class StatOutputPlugin implements PluginLayoutOutput  {
	 	public function __construct($config, $loader) {}
	 	
	 	
		public function cacheable($content, $data) {
			return false;
		}
		
		
	 	public function process($content, $data) {
	 		// Get all parameters
			//  (Note that the "attr"-parameter is the first parameter if a
			//   content is set the second otherwise)
			if(is_string($content)) {
				$filename = trim($content);
				$property = Page::get_param($data, 0, "attr", null);
			} else {
				$filename = trim(Page::get_param($data, 0, "file", ""));
				$property = Page::get_param($data, 1, "attr", null);
			}
			
	 		switch($property) {
				case "ino":
					return fileinode($filename);
				break;
				case "uid":
					return fileowner($filename);
				break;
				case "gid":
					return filegroup($filename);
				break;
				case "size":
					return filesize($filename);
				break;
				case "atime":
					return fileatime($filename);
				break;
				case "mtime":
					return filemtime($filename);
				break;
				case "ctime":
					return filectime($filename);
				break;
				case "dev":
				case "mode":
				case "nlink":
				case "rdev":
				case "blksize":
				case "blocks":
					$stat = stat($this->filename);
					
					return $stat[$this->property];
				break;
				default:
					return null;
			}
	 	}
	 }
