<?php
	/**
	 * Add a smarty prefilter which adds a classed span at every place where the
	 * brand of the page occures
	 *
	 * @param string $source The source of the page
	 * @param Smarty $smarty The Smarty object
	 *
	 * @return string
	 */
	function smarty_prefilter_brand($source, &$smarty)
	{
		global $_CONFIG;
		
		if(isset($_CONFIG['name']) && $_CONFIG['name'])
		{
			$fragments = explode($_CONFIG['name'], $source);
			$source    = $fragments[0];
			for($x=1; $x < count($fragments); $x++)
			{
				$last_char = str_split($source);
				$last_char = end($last_char);
				if($last_char == "\n" || $last_char == "\r"
				|| $last_char == ' '  || $last_char == '>')
					$source .= "<span class='brand'>{$_CONFIG['name']}</span>";
				else
					$source .= $_CONFIG['name'];
				$source .= $fragments[$x];
			};
		};
		return $source;
	};
