<?php
	/**
	* Smarty plugin
	* -------------------------------------------------------------
	* File:     modifier.url.php
	* Type:     modifier
	* Name:     url
	* Purpose:  Convert an internal url to an url for useage in the
	*           internet.
	* -------------------------------------------------------------
	*/
	function smarty_modifier_filesize($size, $SI=true, $empty='-', $round=2)
	{
		static $filesize_units_p2= array('B', 'KiB', 'MiB', 'GiB', 'TiB', 'PiB', 'EiB', 'ZiB', 'YiB');
		static $filesize_units_SI = array('B', 'KB',  'MB',  'GB',  'TB',  'PB',  'EB',  'ZB',  'YB');
		
		if($size == 0)
			return $empty;
		
		if($SI) {
			$exp   = 1000;
			$units = $filesize_units_SI;
		} else {
			$exp   = 1024;
			$units = $filesize_units_p2;
		}
		
		$i = floor(log($size, $exp));
		return round($size/pow($exp, $i), $round) . ' ' . $units[$i];
	}
