<?php
	/**
	 * Try to find out what search engine and search query is used by URL
	 *
	 * @package aCMS
	 */
	
	
	/**
	 * The main plugin class with common matching methods
	 */
	class SearchEngineMain implements PluginLayoutMain {
		/**
		 * An array of search engines names as keys and regular expressions
		 * matching the search engines URL as value
		 * 
		 * @var array
		 */
		public static $search_engines = array(
			'Google'                => array('google.*',         'q'),
			'Yahoo! Search'         => array('search.yahoo.*',   'p'),
			'bing'                  => array('bing.*',           'q'),
			'yebol'                 => array('yebol.*',          'key'),
			'mugurdy'               => array('mugurdy.com',      'q'),
			'DuckDuckGO'            => array('duckduckgo.*',     'q'),
			'Scroogle'              => array('scroogle.org',     'Gw'),
			'Sperse! Search'        => '^[^:]*://[^/]*sperse\.[^/]*/.*/(.*)(?:-\d+-\d+-\d+.html)?$',
			'Forestle'              => array('forestle.org',     'q'),
			'leapfish'              => array('leapfish.com',     'q'),
			'cuil'                  => array('cuil.com',         'q'),
			'viewzi'                => array('viewzi.com',       3),
			'PICOLLATOR'            => array('picollator.com',   null), // Always overloaded...
			'sproose'               => array('sproose.com',      'query'),
			'guruji'                => array('guruji.com',       'q'),
			'AskJeeves'             => array('uk.ask.com',       'q'),
			'ask.com'               => array('ask.com',          'q'),
			'GoodSearch'            => array('goodsearch.com',   'keywords'),
			'Sogou'                 => array('sogou.*',          'query'),
			'info.com'              => array('info.com',         'qkw'),
			'exalead'               => array('exalead.com',      'q'),
			'百度'                    => array('baidu.*',          'wd'),
			'YippY Search'          => array('search.yippy.com', 'query'),
			'NAVER'                 => array('naver.*',          'query'),
			'alltheweb'             => array('alltheweb.com',    'q'),
			'Яндекс'                => array('yandex.*',         'text'),
			'HotBot'                => array('hotbot.*',         'query'),
			'Dogpile'               => array('dogpile.com',      null),
			'excite'                => array('excite.com',       5),
			'sapo.pt'               => array('sapo.pt',          'q'),
			'altavista'             => array('altavista.*',      'q'),
			'LYCOS'                 => array('laycos.*',         'query'),
			'MetaCrawler'           => array('metacrawler.*',    null),
			'WebCrawler'            => array('webcrawlwer.*',    null),
			'Infoseek Japan'        => array('infoseek.co.jp',   'qt'),
			'Northern Light Search' => array('nlsearch.com',     'textQuery')
		);
		
		
		public function __construct($config, $loader) {}
		
		
		/**
		 * Give back a list of supported plugin types
		 * 
		 * @return list
		 */
		public function supported() {
			return array('output');
		}
		
		/**
		 * Return the current version of this plugin
		 * 
		 * @return string
		 */
		public function get_version() {
			return '1';
		}
	
		/**
		 * Is it always required to include the main plugin file?
		 * 
		 * @return bool
		 */
		public function include_main() {
			return true;
		}
		
		
		/**
		 * Process an URL and return which search engine and query string where
		 * used.
		 * If a field cannot be detected then its value will be null.
		 * 
		 * @param string $url
		 * 
		 * @return array(string, string)
		 */
		public static function parse_url($url) {
			foreach(self::$search_engines as $name => $data) {
				if(is_array($data) && count($data) == 2) {
					$_url = parse_url($url);
					
					// Match only the parts of the host which are defined
					if(isset($_url['host'])) {
						$host = substr_count($data[0], '.') + 1;
						$host = array_slice(explode('.',$_url['host']), -$host);
						$host = implode($host, '.');
					} else {
						$host = '';
					}
					
					if(fnmatch($data[0], $host)) {
						$query = false;
						if(is_string($data[1]) && isset($_url['query'])) {
							$query_array = array();
							parse_str($_url['query'], $query_array);
							
							if(isset($query_array[$data[1]])) {
								$query = $query_array[$data[1]];
							}
						} elseif(is_integer($data[1]) && isset($_url['path'])) {
							if(substr_count($_url['path'], '/') >= $data[1]) {
								$query_array = explode('/', $_url['path']);
								$query = $query_array[$data[1]];
							}
						}
						
						return $query ? array($name,$query) : array($name,null);
					}
				} elseif(is_string($data)) {
					$data = str_replace('/', '\/', $data);
					if(preg_match("/$data/i", $url, $result)) {
						if(count($result) > 1 && !empty($result[1])) {
							return array($name, urldecode($result[1]));
						} else {
							return array($name, null);
						}
					}
				}
			}
			
			return array(null, null);
		}
	}
