<?php
	/**
	 * HTML parser binding for search engine look-up
	 * 
	 * @param Configuration $config  The current configuration object
	 * @param mixed         $loader  The object loading this binding
	 * @param string        $content The content to use as URL if modifying
	 * @param array         $data    The arguments for the look-up
	 */
	class SearchEngineOutputPlugin implements PluginLayoutOutput {
		public function __construct($config, $loader) {}
		
		
		public function cacheable($content, $data) {
			return false;
		}
		
		
		/**
		 * Process a URL and find out if it is a search engine's URL or not
		 * 
		 * If URL is empty then the page's HTTP Referer will be used.
		 * 
		 * If the requested value could be retrieved then it will be returned
		 * otherwise the return value will null.
		 * 
		 * Parameter list: (1)
		 *  +  !content - The URL to process
		 *  1. $get     - The value to retrieve (either "name" or "query")
		 * 
		 * Parameter list: (2)
		 *  1. $url - The URL to process
		 *  2. $get - The value to retrive (either "name" or "query")
		 * 
		 * @return string|null
		 */
		public function process($content, $data) {
			// Get all parameters
			//  (Note that the "get"-parameter is the first parameter if a
			//   content is set the second otherwise)
			if(is_string($content)) {
				$url = trim($content);
				$get = find_param($data, 0, "get", "name");
			} else {
				$url = trim(find_param($data, 0, "url", ""));
				$get = find_param($data, 1, "get", "name");
			}
			// Use the HTTP referer as URL if no URL was setten
			if(!$url && isset($_SERVER['HTTP_REFERER'])) {
				$url = $_SERVER['HTTP_REFERER'];
			}
			
			// Parse the query string
			list($name, $query) = SearchEngineMain::parse_url($url);
			
			// Return the requested value
			if($get == "name") {
				return $name;
			} elseif($get == "query") {
				return $query;
			} else {
				return null;
			}
		}
	}
