<?php
	/**
	 * Parse and display menus
	 *
	 * @package aCMS
	 */

	/**
	 * Parse menu files
	 * 
	 * @param Page  $page   The current page
	 * @param mixed $loader The loading object
	 */
	class MenuMain implements PluginLayoutMain {
		public function __construct($config, $loader) {}
	 	
	 	
	 	/**
	 	 * Give back which plugin types are supported
	 	 * 
	 	 * @return array
	 	 */
		public function supported() {
	 		return array('output_html');
		}
		
		/**
		 * Return the current version of this plugin
		 * 
		 * @return string
		 */
		public function get_version() {
			return '1';
		}
	
		/**
		 * Is it always required to include the main plugin file?
		 * 
		 * @return bool
		 */
		public function include_main() {
			return true;
		}
	 	
	 	
		private static function add_to_end($array, $value, $indent) {
			if($indent > 0) {
				// Get the last key name
				foreach($array as $key => $_);
				
				$array[$key] = self::add_to_end(end($array), $value, $indent-1);
			} else {
				$array[$value] = array();
			}
			
			return $array;
		}
		
		
		public static function parse_menu_string($string) {
			$result = array();
			foreach(explode("\n", $string) as $line) {
				// Ignore empty line
				if(!trim($line)) {
					continue;
				}
				
				// Get all spaces in front of the item name
				$indent = 0;
				while(true) {
					if(substr($line, 0, 1) == "\t") {
						$line = substr($line, 1);
						
						$indent++;
					} elseif(substr($line, 0, 4) == '    ') {
						$line = substr($line, 4);
						
						$indent++;
					} else {
						break;
					}
				}
				
				$result = self::add_to_end($result, trim($line), $indent);
			}
			return $result;
		}
	 	
	 	
		public static function parse_menu_file($filename) {
			return self::parse_menu_string(file_get_contents($filename));
		}
	}
