<?php
	class MenuHtmlOutputPlugin implements PluginLayoutOutputHtml {
	 	public function __construct($config, $loader) {
			$this->config = $config;
			$this->loader = $loader;
			$this->page   = $this->config->runtime()->fetch('*page.stream');
	 	}
	 	
	 	
		public function cacheable($content, $data) {
			return true;
		}
		
		
	 	public function process($content, $data) {
	 		//TODO: Put menu file in a better place
			list($indent, $menu) = find_params($data, array(
			  "indent" => '',
			  "menu"   => null,
			));
			if(is_string($menu)) {
				$menu = MenuMain::parse_menu_file("{$this->config->get_config('*dwoo.theme.directory')}/{$this->config->get_config('*dwoo.theme.current')}/${menu}.txt");
			} elseif(!is_array($menu)) {
				$menu = MenuMain::parse_menu_file(
				  "{$this->config->get_config('*dwoo.theme.directory')}/{$this->config->get_config('*dwoo.theme.current')}/menu.txt"
				);
			}
			
			return $this->generate($indent, $menu);
		}
		
		
		protected function generate($indent, $menu) {
	 		$msg = "{$indent}<ul>\n";
			foreach($menu as $item => $children) {
				$loader = new PluginLoader('page', $this->config);
				$page   = $loader->load(
				  'stream', $this, $item, 'r', $this->page->get_params()
				);
				$title = $this->page->find_title($item, true);
				// TODO: Detect and process query strings in the menu
				$url   = UrlMain::get_url("page://{$item}");
				
				$title = $title ? $title : $item;
				
				// Add special class name if this item is the current page
				if($this->page->get_name() == $item) {
					$msg .= "{$indent}\t<li class=\"current\">\n";
				} else {
					$msg .= "{$indent}\t<li>\n";
				}
				
				if($this->page->get_name() == $item || !$page->exists()) {
					$msg .= "{$indent}\t\t{$title}\n";
				} else {
					$msg .= "{$indent}\t\t<a href=\"{$url}\">{$title}</a>\n";
				}
				
				// TODO: Level based menu
				if(count($children) > 0) {
					$msg .= $this->generate("{$indent}\t\t\t", $children);
				}
				$msg .= "{$indent}\t</li>\n";
			}
			$msg .= "{$indent}</ul>\n";
			
			return $msg;
	 	}
	 }
