<?php
	/**
	 * A plugin that allows a lot of stuff to be done with CSS files before they
	 * are sent to the client
	 * 
	 * @package aCMS-plugins
	 */
	 
	 class CssMain implements PluginLayoutMain {
	 	public function __construct($config, $loader) {}
	 	
	 	
	 	public function supported() {
	 		return array('stream');
	 	}
		
		/**
		 * Return the current version of this plugin
		 * 
		 * @return string
		 */
		public function get_version() {
			return '1.0a1';
		}
		
		/**
		 * Is it always required to include the main plugin file?
		 * 
		 * @return bool
		 */
		public function include_main() {
			return true;
		}
		
		
		/**
		 * Compress a CSS file using the unmodified CSS packer component of z_packer
		 * 
		 * @copyright (c) z3n - R1V1@090403 - CSS Packer - www.overflow.biz - z3n666@gmail.com
		 * @see http://www.overflow.biz/blog/2009/04/03/js-and-css-packer-in-php/
		 * 
		 * @param string $x
		 *        The CSS data to process
		 * @return string
		 */
		static public function compress($x) {
			return preg_replace(array('!//[^\n\r]+!','/[\r\n\t\s]+/s','#/\*.*?\*/#','/[\s]*([\{\},;:])[\s]*/','/^\s+/'),array('',' ','','\1',''),$x);
		}
	 }
