<?php
	require_once(dirname(__FILE__) . '/' . "../../../aCMS-base/plugins/url/plugin.php");
	
	class BreadcrumbHtmlOutputPlugin implements PluginLayoutOutputHtml {
		public function __construct($config, $loader) {
			$this->config = $config;
			$this->loader = $loader;
			$this->page   = $config->runtime()->fetch('*page.stream');
		}
		
		
		public function cacheable($content, $data) {
			return true;
		}
		
		
		public function process($content, $data) {
			list($sep, $classname, $reverse, $homepage, $lang) = 
			  find_params($data, array(
			    "sep"       => " &raquo; ",
			    "classname" => "breadcrumb_item",
			    "reverse"   => "false",
			    "homepage"  => $this->config->config()->fetch("*page.name"),
			    "lang"      => $this->page->get_language()
			  ));
			$reverse = ($reverse == "false") ? false : true;
			
			//TODO: Improve code
			$crumb = '';
			$title = $this->page->find_title($homepage);
			if($this->page->get_name() == $homepage) {
				return "<span class=\"{$classname}\">{$title}</span>";
			} else {
				// TODO: Implement URL creator as shared code...
				$url    = UrlMain::get_url($homepage);
				$crumb .= "<a class=\"{$classname}\" href=\"{$url}\">";
				$crumb .= "{$title}</a>{$sep}";
			}
			
			$items = $this->page->get_page_title(null, false, $reverse);
			
			foreach($items as $name => $title) {
				$loader = new PluginLoader('page', $this->config);
				$page   = $loader->load(
				  'stream', $this, $name, 'r', $this->page->get_params()
				);
				$url = UrlMain::get_url($name);
				
				// Current page
				if($name == $this->page->get_name() || !$page->exists()) {
					$crumb .= "<span class=\"{$classname}\">{$title}</span>";
				} else {
					$crumb .= "<a class=\"{$classname}\" href=\"{$url}\">{$title}</a>";
				}
				
				$crumb .= $sep;
			}
			
			// Cut off the last seperator before returning
			return substr($crumb, 0, -strlen($sep));
		}
	}
