<?php
	function fixpath($path, $seperator=null) {
		if(strpos($path, '://', 1) > -1) { // URL
			// Don't process URL scheme
			list($scheme, $path) = explode('://', $path, 2);
			
			// Don't process username, password, hostname and port fields
			if(strpos($path, '/') !== false) {
				list($host, $path) = explode('/', $path, 2);
			} else {
				$host = $path;
				$path = '';
			}
			
			$prefix  = "{$scheme}://{$host}/";
			$process = false;
			$sep     = '/';
		} elseif(substr($path, 0, 2) == "\\\\") { // UNC path (Windows)
			$path    = substr($path, 2);
			$prefix  = "\\\\";
			$process = true;
			$sep     = "\\";
		} elseif(substr($path, 1, 2) == ":\\") { // Absolute path (Windows)
			$prefix  = substr($path, 0, 1) . ":\\";
			$path    = substr($path, 3);
			$process = true;
			$sep     = "\\";
		} elseif(substr($path, 0, 1) == '/') { // Absolute path (POSIX)
			$path    = substr($path, 1);
			$prefix  = '/';
			$process = true;
			$sep     = '/';
		} else { // Relativ path
			$path    = $path;
			$prefix  = '';
			$process = true;
			$sep     = DIRECTORY_SEPARATOR;
		}
		
		// Unify seperators for easier parsing
		$path = str_replace('\\', '/', $path);
		
		// Remove double, trible, ... slashes
		while(strpos($path, '//') > -1) {
			$path = str_replace('//', '/', $path);
		}
		
		// Remove slashes at the beginning and end of the path
		if(substr($path, 0, 1) == '/') {
			$path = substr($path, 1);
		}
		if(substr($path, strlen($path)-1) == '/') {
			$path = substr($path, 0, strlen($path)-1);
		}
		
		$result = array();
		foreach(explode('/', $path) as $part) {
			// Skip current directory notations
			if($part == '.') {
				continue;
			}
			// Move up by one in our virtual hierachie by one if the parent
			// directory notation is encountered
			if($part == '..') {
				array_pop($result);
				continue;
			}
			
			// Add all normal entries to the hierachie
			$result[] = $part;
			
			// Resolve symlinks if the path should be processed
			if($process) {
				$current = $prefix . implode($result, $sep);
				// Read the symbolic link and store it as the new path
				if(($realpath=realpath($current)) !== FALSE) {
					$result = explode($sep, substr($realpath, strlen($prefix)));
				}
			}
		}
		
		if($seperator) {
			return $prefix . implode($result, $seperator);
		} else {
			return $prefix . implode($result, $sep);
		}
	}
