<?php
	class UrlMain implements PluginLayoutMain {
		public function __construct($config, $loader) {}
		
		
		/**
		 * Return the current version of this plugin
		 * 
		 * @return string
		 */
		public function get_version() {
			return '1';
		}
		
		
		/**
		 * Is it always required to include the main plugin file?
		 * 
		 * @return bool
		 */
		public function include_main() {
			return true;
		}
		
		/**
		 * Return a list of supported plugin types
		 * 
		 * @return array
		 */
		public function supported() {
			return array('output', 'filter_dwoo_pre');
		}
		
		
		/**
		 *
		 * If $uri is a client-side (mailto:, data:, callto:, ...) or absolute
		 * path (/*, *://*, *:\*, ...) it will be used as-is, otherwise, if it
		 * was provided, $base will be added before $uri.
		 * 
		 * @param string  $uri
		 *        The URL which should be processed
		 * @param string [$base]
		 *        The base path of this URL
		 * @return string
		 */
		public static function get_url($uri, $base=null) {
			// Don't process client-side URLs (mailto:, data:, callto:, ...)
			if(preg_match("/^[A-Za-z]+[:][^\\/]+.*$/i", $uri)) {
				return $uri;
			}
			
			// Add base if the path is not aboslute
			if(is_string($base)) {
				if((substr($uri, 0, 1) != '/')   // Unix absolute path
				&& (substr($uri, 0, 1) != '\\')  // Windows absolute drive path
				&& (substr($uri, 0, 2) != '\\\\')// Windows absolute network path
				&& (substr($uri, 1, 2) != ':\\') // Windows absolute local path
				&& (strpos($uri, '://') === FALSE)) { // URL
					$uri = $base . '/' . $uri;
				}
			}
			
			$data = parse_url($uri);
			// Ignore all non-stream entries
			if(isset($data['scheme'])) {
				// Generate the request path
				if(isset($data['path'])) {
					$name = "{$data['host']}/{$data['path']}";
				} else {
					$name = $data['host'];
				}
				// Generate the parameter array
				$params = array();
				if(isset($data['query'])) {
					parse_str($data['query'], $params);
				}
				$params = array_merge($_POST, $_GET, $params);
				
				// Load a plugin with by name of the scheme used
				$loader = new PluginLoader($data['scheme']);
				$plugin = $loader->load('stream', null, $name, 'r', $params);
				// Check if this url wrapper was actually an aCMS stream
				if(is_object($plugin)) {
					// Use generated URL if there is any
					if(is_callable(array($plugin, 'generate_url'))
					&& is_string($new_uri=$plugin->generate_url())) {
						$uri = $new_uri;
					// Use default index.php URL handling
					} else {
						$uri  = basename($_SERVER["SCRIPT_FILENAME"]);
						$uri .= "?type={$data['scheme']}&resource={$name}";
					}
				}
			}
			
			// Append query string and fragment to the URL
			if(isset($data['query'])) {
				if(strpos($uri, '?') !== false) {
					$uri .= "&{$data['query']}";
				} else {
					$uri .= "?{$data['query']}";
				}
			}
			if(isset($data['fragment'])) {
				$uri .= "#{$data['fragment']}";
			}
			
			// Absolutize URI
			if(substr($uri, 0, 1) != '/' && strpos($uri, '://') === false) {
				$uri = dirname($_SERVER['SCRIPT_NAME']) . '/' . $uri;
			}
			
			return fixpath($uri);
		}
	}
