<?php
	/**
	 * A plugin class allowing you change all links stored in a page to real
	 * URLs
	 */
	class UrlPreDwooFilterPlugin extends Dwoo_Processor implements PluginLayoutFilterDwooPre {
		public function __construct($config, $loader) {
			$this->config  = $config;
			$this->loader  = $loader;
		}
		
		
		public function process($content) {
			$tags  = 'a|form|img|link|script|frame|iframe';
			$attrs = 'action|href|src';
			$value = "(?:'[^'\r\n]*')|(?:\"[^\"\r\n]*\")|(?:[^ \r\n]+)";
			
			$matches = array();
			preg_match_all(
					"/<(?:$tags)(?:\s+(?:(?:$attrs)=($value)|[\w-]+(?:=$value)?))+\s*\/?>/iu",
					$content,
					$matches,
					PREG_SET_ORDER
			);
			
			foreach($matches as $match) {
				if(!isset($match[1]) || !trim($match[1])) {
					continue;
				}
				
				if((substr($match[1], 0, 1) == '"' && substr($match[1], -1) == '"')
				|| (substr($match[1], 0, 1) == "'" && substr($match[1], -1) == "'")) {
					$match[1] = substr($match[1], 1, -1);
				}
				
				$url = UrlMain::get_url(html_entity_decode($match[1]));
				$url = str_replace('&', '&amp;', $url);
				
				$tag     = str_replace($match[1], $url, $match[0]);
				$content = str_replace($match[0], $tag, $content);
			}
			
			return $content;
		}
	}
