<?php
	/**
	 * 
	 *
	 * @package aCMS-plugins
	 */
	require_component("classes/Configuration.class.php");
	
	
	
	class PostgresqlConfigurationPlugin extends PluginHelperConfigurationPDO implements PluginLayoutConfiguration {
		/**
		 * SQL command to create a new table in the database
		 */
		const SQL_TABLE_CREATE = '
CREATE TABLE
	"$table"
(
	"section" character varying(255) NOT NULL,
	"name"    character varying(255) NOT NULL,
	"value"   text,
	"type"    character(2) NOT NULL DEFAULT \'ss\'
) WITH (
	OIDS = TRUE
);		';
		
		/**
		 * SQL command to fetch all data entries from the table
		 */
		const SQL_TABLE_FETCH = '
SELECT
	"name",
	"section",
	"value",
	"type"
FROM
	"$table"
;		';
		
		/**
		 * SQL command to fetch all configuration data entries of a certain
		 * section from the table
		 */
		const SQL_SECTION_FETCH = '
SELECT
	"name",
	"value",
	"type"
FROM
	"$table"
WHERE
	section = \'$section\'
;		';
		
		/**
		 * SQL command to create/insert a new configuration item into the
		 * configuration table
		 */
		const SQL_ITEM_CREATE = '
INSERT INTO
	"$table"
(
	"section",
	"name",
	"value",
	"type"
) VALUES (
	\'$section\',
	\'$name\',
	\'$value\',
	\'$type\'
);		';
		
		/**
		 * SQL command to check if a configuration item exists
		 */
		const SQL_ITEM_EXISTS = '
SELECT
	count(*)
FROM
	"$table"
WHERE
	"section" = \'$section\' AND
	"name"    = \'$name\'
;		';
		
		/**
		 * SQL command to fetch a configuration item limited by its name and
		 * section from the data
		 * 
		 * You might want to use the following SQL extensions in your
		 * SQL command: LIMIT = 1
		 */
		const SQL_ITEM_FETCH = '
SELECT
	"value",
	"type"
FROM
	"$table"
WHERE
	"section" = \'$section\' AND
	"name"    = \'$name\'
LIMIT
	1
;		';
		
		/**
		 * SQL command to change to value of a configuration item inside of the
		 * configuration table
		 */
		const SQL_ITEM_UPDATE = '
UPDATE
	"$table"
SET
	"value" = \'$value\'
WHERE
	"section" = \'$section\' AND
	"name"    = \'$name\'
;		';
		
		
		
		/**
		 * @param Configuration           $config The current configuration
		 * @param mixed                   $loader The loading object
		 * @param ConfigurationConnection $data   How to connect to the server
		 */
		public function __construct($config, $loader, $data) {
			$this->config = $config;
			$this->loader = $loader;
			
			$this->construct_helper(
					$data,
					"pgsql:host='{$data->hostname}';dbname='{$data->database}'"
			);
		}
	}
