<?php
	/**
	 * 
	 * 
	 * @project aCMS-plugins
	 */
	require_once(dirname(__FILE__) . '/' . "Dwoo/dwooAutoload.php");
	
	
	
	class DwooError extends AOFError {}
	
	
	class DwooRendererPlugin extends Dwoo implements PluginLayoutRenderer {
		/**
		 * @param Configuration $config The current configuration
		 * @param Page          $page   The loading Page object
		 */
		public function __construct($config, $page) {
			$this->config = $config;
			$this->page   = $page;
			
			// Initialize parent
			parent::__construct();
			
			$cache_directory = $config->config()->fetch('*cache.directory');

			try {
				// Create and set Dwoo compile directory
				$compiledir = "{$cache_directory}/dwoo/compiled";
				if(!is_dir($compiledir)) {
					mkdir($compiledir, 0777, true);
				}
				$this->setCompileDir($compiledir);

				// Create and set Dwoo cache directory
				$cachedir = "{$cache_directory}/dwoo/cache";
				if(!is_dir($cachedir)) {
					mkdir($cachedir, 0777, true);
				}
				$this->setCacheDir($cachedir);

				// Add Dwoo native plugin directories to Dwoo search path
				$loader = new Dwoo_Loader($this->getCompileDir());
				foreach(PluginLoader::get_search_path(array('./others/dwoo')) as $plugindir) {
					if(is_dir($plugindir)) {
						$loader->addDirectory($plugindir);
					}
				}
				$this->setLoader($loader);

				// Register all PHP stream wrappers as Dwoo templates
				foreach(stream_get_wrappers() as $scheme) {
					if($scheme != "file" && $scheme != "string") {
						$this->addResource($scheme, "Dwoo_Template_Stream");
					}
				}

				// Set aCMS Dwoo plugin proxy
				$this->setPluginProxy(
				new Dwoo_Adapters_aCMS_PluginProxy($config, $this)
				);
			} catch(Dwoo_Exception $error) {
				throw new DwooError($error->getMessage());
			}
		}
		
		
		/**
		 * Display this page
		 */
		public function display() {
			// Set template directory
			$themedir  = "{$this->config->config()->fetch('theme.directory')}/";
			$themedir .= "{$this->config->config()->fetch('theme.current')}";
			
			if(!$this->config->config()->fetch('theme.current')) {
				throw new DwooError("No default theme set!");
			}
			
			try {
				// Load template
				$template = new Dwoo_Template_File("{$themedir}/dwoo.tpl");

				// Always recompile templates (caching is done at top-level)
				$template->forceCompilation();

				// Create Dwoo template compiler
				$compiler = new Dwoo_Compiler();

				// Add all defined prefilters to the compiler
				foreach((array) $this->config->config()->fetch("filters.pre") as $filter) {
					$loader = new PluginLoader($filter, $this->config);
					$plugin = $loader->load("filter_dwoo_pre", $this);

					if(!is_object($plugin)) {
						throw new DwooError(
								"Requested Dwoo pre-filter '{$filter}' does " .
								"not exist or is not a Dwoo pre-filter"
						);
					}
					if(!($plugin instanceof Dwoo_Processor)) {
						throw new DwooError(
								"Requested Dwoo pre-filter '{$filter}' is " .
								"not an instance of the Dwoo_Processor class"
						);
					}
					$compiler->addPreProcessor(array($plugin, "process"));
				}

				// Add all defined post-compilation filters to the compiler
				foreach((array) $this->config->get_config("filters.post") as $filter) {
					$loader = new PluginLoader($filter, $this->config);
					$plugin = $loader->load("filter_dwoo_post", $this);

					if(!is_object($plugin)) {
						throw new DwooError(
							"Requested Dwoo post-filter '{$filter}' does not exist"
						);
					}
					if(!($plugin instanceof Dwoo_Processor)) {
						throw new DwooError(
							"Requested Dwoo post-filter '{$filter}' is not an " .
							"instance of the Dwoo_Processor class"
						);
					}
					$compiler->addPreProcessor(array($plugin, "process"));
				}

				// Create data object
				$data = new Dwoo_Data();
				$data->assign("config",
				$this->config->main()->config()->fetch_all()
				);
				$data->assign("runtime",
				$this->config->main()->runtime()->fetch_all()
				);
				$data->assign("storage",
				$this->config->main()->storage()->fetch_all()
				);

				$data->assign("directories", array(
				"theme" => $themedir
				));

				$data_page = array(
				"name"     => $this->page->get_name(),
				"language" => $this->page->get_language(),
				"object"   => $this->page,
				"titles"   => array(
					"page" => $this->page->get_page_title(' - ', true, true, true),
					"h1"   => $this->page->find_title($this->page)
				)
				);
				if(!$data_page["titles"]["page"]) {
					$data_page["titles"]["page"] = $this->page->get_name();
				}
				if(!$data_page["titles"]["h1"]) {
					$data_page["titles"]["h1"] = $this->page->get_name();
				}
				$data->assign("page", $data_page);

				return $this->output($template, $data, $compiler);
			} catch(Dwoo_Exception $error) {
				throw new DwooError($error->getMessage());
			}
		}
		
		
		/**
		 * Render the page and return the resulting HTML
		 * 
		 * @return string
		 */
		public function get_content() {
			ob_start();
			
			$this->display();
			
			return ob_get_clean();
		}
	}
	
	
	
	/**
	 * A Dwoo template class which allows you to use any PHP stream within Dwoo
	 */
	class Dwoo_Template_Stream extends Dwoo_Template_String {
		/**
		 * The URL of the stream to use
		 * 
		 * @var string
		 */
		protected $location = "";
		
		
		/**
		 * A cached version of the template source
		 * 
		 * @var string
		 */
		protected $source;
		
		
		
		/**
		 * creates a template from a string
		 *
		 * @param string   $location
		 *        {@see $location}
		 * @param int|null $cacheTime
		 *        {@see parent::$cacheTime}
		 * @param string $cacheId
		 *        The unique cache identifier of this page or anything else that
		 *        makes this template's content unique, if null it defaults to
		 *        the current url
		 * @param string $compileId
		 *        The unique compiled identifier, which is used to distinguish
		 *        this template from others, if null it defaults to the md4 hash
		 *        of the template
		 */
		public function __construct($location, $cacheTime=null, $cacheId=null, $compileId=null) {
			$this->location = $location;
			$this->name     = basename($location);
			$this->setCacheTime($cacheTime);
			
			if($compileId !== null) {
				$this->compileId = str_replace('../', '__', strtr($compileId, '\\%?=!:;'.PATH_SEPARATOR, '/-------'));
			}
			
			if($cacheId !== null) {
				$this->cacheId = str_replace('../', '__', strtr($cacheId, '\\%?=!:;'.PATH_SEPARATOR, '/-------'));
			}
		}
		
		
		/**
		 * Returns the resource name of this template class
		 * 
		 * @return string
		 */
		public function getResourceName() {
			return parse_url($this->location, PHP_URL_SCHEME);
		}
		
		
		/**
		 * Return the location of this template
		 * 
		 * @throws Dwoo_Exception
		 * @return string|false
		 */
		public function getResourceIdentifier() {
			$result = fopen($this->location);
			if(is_resource($result)) {
				fclose($result);
				return $this->location;
			} else {
				throw new Dwoo_Exception("Invalid stream location: {$this->location}");
			}
		}
		
		
		/**
		 * Return the unprocessed data of this template
		 *
		 * @return string
		 */
		public function getSource() {
			if(!$this->source) {
				$this->source = file_get_contents($this->location);
			}
			
			return $this->source;
		}
		
		
		/**
		 * Return an unique string identifying this specific version of the
		 * template: The Unix timestamp of last modification or a hash of the
		 * template source if the first one is not available
		 * 
		 * @return string
		 */
		public function getUid() {
			$mtime = @filemtime($this->getResourceIdentifier());
			if($mtime) {
				return (string) $mtime;
			} else {
				return "";
//				if(function_exists('hash')) {
//					return hash('md4', $this->getSource());
//				} else {
//					return md5($this->getSource());
//				}
			}
		}
		
		
		/**
		 * Return null to tell Dwoo compiler to check the Uid code itself
		 * 
		 * @return null
		 */
		public function getIsModifiedCode() {
			return "'{$this->getUid()}' == @filemtime('{$this->getResourceIdentifier()}')";
		}
		
		
		/**
		 * returns a new template object from the given resource identifier, null if no include is
		 * possible (resource not found), or false if include is not permitted by this resource type
		 *
		 * this method should also check if $dwoo->getSecurityPolicy() is null or not and do the
		 * necessary permission checks if required, if the security policy prevents the template
		 * generation it should throw a new Dwoo_Security_Exception with a relevant message
		 *
		 * @param string $location_path
		 *        The path of the resource (e.g.: abc/def)
		 * @param int    $cache_time
		 *        How long the cache of this template is valid
		 * @param string $cacheId
		 *        The unique cache identifier of this page or anything else that
		 *        makes this template's content unique, if null it defaults to
		 *        the current url
		 * @param string $compileId
		 *        The unique compiled identifier, which is used to distinguish
		 *        this template from others, if null it defaults to the
		 *        filename+bits of the path
		 * @param Dwoo_ITemplate $parent
		 *        The parenting template of this one
		 * @return Dwoo_Adapters_aCMS_Template|false
		 */
		public static function templateFactory(Dwoo $dwoo, $location_path, $cacheTime=null, $cacheId=null, $compileId=null, Dwoo_ITemplate $parent=null) {
			// Generate $location_scheme from stack trace through the arguments
			// passed to $dwoo->templateFactory()
			//TODO: Stop hacking, start coding!
			if(version_compare(PHP_VERSION, '5.4.0') >= 0) {
				// Limit the number of stack frames returned (added in PHP 5.4)
				$frames = debug_backtrace(0, 3);
			} else {
				$frames = debug_backtrace(false);
			}
			$location_scheme = $frames[2]["args"][0];
			
			// Make sure the path used is valid
			if(substr($location_path, 0, 2) != '//') {
				$location_path = "//{$location_path}";
			}
			
			$location = "{$location_scheme}:{$location_path}";
			return new self($location, $cacheTime, $cacheId, $compileId);
		}
	}
	
	
	
	
	/**
	 * The Dwoo adapter for the aCMS plugin system
	 */
	class Dwoo_Adapters_aCMS_PluginProxy implements Dwoo_IPluginProxy {
		public function __construct($config, $loader) {
			$this->config = $config;
			$this->loader = $loader;
		}
		
		
		public function callPlugin($name, $content, $params) {
			//WORKAROUND: Strange effects when calling a function named "url"
			if($name == 'url2') {
				$name = 'url';
			}
			
			$loader = new PluginLoader($name, $this->config);
			
			if($loader->is_supported("output_html")) {
				$type = "output_html";
			} elseif($loader->is_supported("output")) {
				$type = "output";
			} else {
				return false;
			}
			
			$plugin = $loader->load($type, $this->loader);
			
			if($plugin->cacheable($content, $params)) {
				return $plugin->process($content, $params);
			} else {
				return "<\$PROCESS_PLUGIN '{$name}' '{$type}' '{$content}' \"".var_export($params, true)."\"\$>";
			}
		}
		
		
		/**
		 * A reference function for Dwoo to find out about the plugins
		 * parameters
		 */
		public function callPluginAPI(array $rest=array()) {}
		
		
		/**
		 * returns true or false to say whether the given plugin is handled by this proxy or not
		 *
		 * @param string $name the plugin name
		 * @return bool true if the plugin is known and usable, otherwise false
		 */
		public function handles($name) {
			//WORKAROUND: Strange effects when calling a function named "url"
			if($name == 'url2') {
				$name = 'url';
			}
			
			$loader = new PluginLoader($name, $this->config);
			return $loader->is_supported("output_html") || $loader->is_supported("output");
		}
	
		/**
		 * returns the code (as a string) to call the plugin
		 * (this will be executed at runtime inside the Dwoo class)
		 *
		 * @param string $name the plugin name
		 * @param array $params a parameter array, array key "*" is the rest array
		 * @return string
		 */
		public function getCode($name, $params) {
			//WORKAROUND: Strange effects when calling a function named "url"
			if($name == 'url2') {
				$name = 'url';
			}
			
			// Treat first parameter as content data if it was called during the
			// modifier processing
			//TODO: Stop hacking, start coding!
			if(version_compare(PHP_VERSION, '5.4.0') >= 0) {
				// Limit the number of frames for PHP 5.4+
				$frames = debug_backtrace(0, 3);
			} else {
				$frames = debug_backtrace(false);
			}
			if($frames[2]["function"] == "replaceModifiers") {
				$content = var_export(array_shift($params["*"]), true);
			} else {
				$content = "null";
			}
			
			if(count($params) > 0) {
				return '$this->getPluginProxy()->callPlugin("'.$name.'", '.$content.', '.Dwoo_Compiler::implode_r($params).')';
			} else {
				return '$this->getPluginProxy()->callPlugin("'.$name.'", '.$content.', array())';
			}
		}
	
		/**
		 * returns a callback to the plugin, this is used with the reflection API to
		 * find out about the plugin's parameter names etc.
		 *
		 * should you need a rest array without the possibility to edit the
		 * plugin's code, you can provide a callback to some
		 * other function with the correct parameter signature, i.e. :
		 * <code>
		 * return array($this, "callbackHelper");
		 * // and callbackHelper would be as such:
		 * public function callbackHelper(array $rest=array()){}
		 * </code>
		 *
		 * @param string $name the plugin name
		 * @return callback
		 */
		public function getCallback($name) {
			return array($this, "callPluginAPI");
		}
	
		/**
		 * returns some code that will check if the plugin is loaded and if not load it
		 * this is optional, if your plugins are autoloaded or whatever, just return an
		 * empty string
		 *
		 * @param string $name the plugin name
		 * @return string
		 */
		public function getLoader($name) {
			var_dump("getLoader", $name);
		}
	}
