<?php
	/**
	 * Plugin binding aCMS to the Dwoo templating engine
	 * 
	 * @package aCMS
	 * @subpackage plugins
	 */
	
	/**
	 * Interface defining a Dwoo filter plugin
	 * 
	 * All Dwoo filters must extend the Dwoo_Processor class!
	 * 
	 * This interface does not extend PluginLayoutFilter since PHP then
	 * complains about process() being defined both in here and in the
	 * Dwoo_Processor class.
	 */
	interface PluginLayoutFilterDwoo extends PluginLayoutPlugin {
		// PHP does not like when the same thing is declared twice
		// (Dwoo_Processor & PluginLayoutFilter) so we skip the declaration here
		//public function process($content)
	}
	
	/**
	 * Interface defining a Dwoo pre-filter plugin
	 * 
	 * Pre-filters are called before the Dwoo template is processed
	 */
	interface PluginLayoutFilterDwooPre  extends PluginLayoutFilterDwoo {}
	
	/**
	 * Interface defining a Dwoo post-filter plugin
	 * 
	 * Post-filters are called after the Dwoo template is processed
	 */
	interface PluginLayoutFilterDwooPost extends PluginLayoutFilterDwoo {}
	
	
	
	
	class DwooMain implements PluginLayoutMain {
		public function __construct($config, $loader) {}
		
		
		public function supported() {
			return array("renderer");
		}
		
		
		public function get_version() {
			return "1.1.1";
		}
		
		/**
		 * Is it always required to include the main plugin file?
		 * 
		 * @return bool
		 */
		public function include_main() {
			return true;
		}
	}
