<?php
	/**
	 * A plugin that implements a stream which allows you to read content data
	 * and output it to the user.
	 *
	 * @package aCMS-plugins
	 */
	
	/**
	 * The layout for the resources providing content types
	 */
	interface PluginLayoutResourceContent extends PluginLayoutResource {
		/**
		 * Return the MIME type of the content resource used
		 * 
		 * @return string
		 */
		public function get_mime_type();
	}
	
	
	
	class ContentMain implements PluginLayoutMain {
		public function __construct($config, $loader) {}
		
		public function supported() {
			return array('stream');
		}
		
		/**
		 * Return the current version of this plugin
		 * 
		 * @return string
		 */
		public function get_version() {
			return '1';
		}
		
		/**
		 * Is it always required to include the main plugin file?
		 * 
		 * @return bool
		 */
		public function include_main() {
			return true;
		}
	}
