<?php
	if(function_exists('finfo_file'))
	{
		function mimetype($filename)
		{
			static $finfo;
			
			if(!isset($finfo)) 
				$finfo = finfo_open(FILEINFO_MIME);
			
			return finfo_file($finfo, $filename);
		}
	}
	elseif(function_exists('mime_content_type'))
	{
		function mimetype($filename) 
		{
			return mime_content_type($filename);
		}
	}
	else
	{
		function mimetype($f)
		{
			$f = escapeshellarg($f);
			return trim(`file -b --mime-type $f`);
		}
	}
