<?php
	/**
	 * Set up the CMS environment
	 * 
	 * @package aCMS
	 */
	$INITTIME = microtime(true);
	
	/**
	 * Enable detailed error_reporting:
	 */
	ini_set('error_reporting', E_ALL | E_STRICT);
	ini_set('report_memleaks', 1);
	
	/**
	 * Disable output compression - we take care of that on a per-request basis
	 */
	ini_set("zlib.output_compression", 0);
	ini_set("zlib.output_compression_level", 0);
	ini_set("zlib.output_handler", '');
	
	
	/**
	 * Disable register_globals if enabled
	 */
	if(ini_get('register_globals')) {
		require_once(__DIR__ . '/' . 'report.inc.php');
		
		report(DEBUG,   'base', "register_globals activated, deactivating...");
		report(WARNING, 'base', "register_globals is a security issue!");
		
		ini_set('register_globals', 0);
		
		$ignore = array(
			'_CONFIG', '_POST', '_COOKIE', '_STORE', '_RUNTIME',
			'_SERVER', '_ENV',  '_GET',    '_FILES', 'GLOBALS');
		$globals = array_merge(
			$_GET, $_POST, $_COOKIE, $_SERVER, $_ENV, $_FILES);
		
		foreach($globals as $key => $value) {
			if(!in_array($key, $ignore) && isset($GLOBALS[$key])) {
				unset($GLOBALS[$key]);
			}
		}
	}
	
	/**
	 * Disable expose_php if needed
	 */
	if(ini_get('expose_php')) {
		ini_set('expose_php', 0);
		header('X-Powered-By:');
	}
	
	/**
	 * Disable magic_quotes_gpc if required
	 */
	if(get_magic_quotes_gpc()) {
		require_once(__DIR__ . '/' . 'report.inc.php');
		
		report(DEBUG, 'base', "magic_quotes_gpc activated, deactivating...");
		report(WARN,  'base', "magic_quotes_gpc is a security issue!");
		
		ini_set('magic_quotes_gpc', 0);
		
		function stripslashes_recusive($value) {
			if(is_array($value)) {
				return array_map('stripslashes_recusive', $value);
			} else {
				return stripslashes($value);
			}
		}
		
		$_GET     = array_map('stripslashes_recusive', $_GET);
		$_POST    = array_map('stripslashes_recusive', $_POST);
		$_COOKIE  = array_map('stripslashes_recusive', $_COOKIE);
		$_REQUEST = array_map('stripslashes_recusive', $_REQUEST);
	}
	
	/**
	 * Filter NUL-bytes from all input arrays
	 */
	function strip_NUL_bytes_recusive($value) {
		if(is_array($value)) {
			return array_map('strip_NUL_bytes_recusive', $value);
		} else {
			return str_replace("\x00", "", $value);
		}
	}
	$_GET     = array_map('strip_NUL_bytes_recusive', $_GET);
	$_POST    = array_map('strip_NUL_bytes_recusive', $_POST);
	$_COOKIE  = array_map('strip_NUL_bytes_recusive', $_COOKIE);
	$_REQUEST = array_map('strip_NUL_bytes_recusive', $_REQUEST);
	
	/**
	 * Set up include path
	 */
	$peardir = __DIR__ . '/' . "3rd-party";
	set_include_path(get_include_path() . PATH_SEPARATOR . $peardir);
