<?php
class ConfigurationFileParser_yyToken implements ArrayAccess
{
    public $string = '';
    public $metadata = array();

    function __construct($s, $m = array())
    {
        if ($s instanceof ConfigurationFileParser_yyToken) {
            $this->string = $s->string;
            $this->metadata = $s->metadata;
        } else {
            $this->string = (string) $s;
            if ($m instanceof ConfigurationFileParser_yyToken) {
                $this->metadata = $m->metadata;
            } elseif (is_array($m)) {
                $this->metadata = $m;
            }
        }
    }

    function __toString()
    {
        return $this->_string;
    }

    function offsetExists($offset)
    {
        return isset($this->metadata[$offset]);
    }

    function offsetGet($offset)
    {
        return $this->metadata[$offset];
    }

    function offsetSet($offset, $value)
    {
        if ($offset === null) {
            if (isset($value[0])) {
                $x = ($value instanceof ConfigurationFileParser_yyToken) ?
                    $value->metadata : $value;
                $this->metadata = array_merge($this->metadata, $x);
                return;
            }
            $offset = count($this->metadata);
        }
        if ($value === null) {
            return;
        }
        if ($value instanceof ConfigurationFileParser_yyToken) {
            if ($value->metadata) {
                $this->metadata[$offset] = $value->metadata;
            }
        } elseif ($value) {
            $this->metadata[$offset] = $value;
        }
    }

    function offsetUnset($offset)
    {
        unset($this->metadata[$offset]);
    }
}

class ConfigurationFileParser_yyStackEntry
{
    public $stateno;       /* The state-number */
    public $major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
    public $minor; /* The user-supplied minor token value.  This
                     ** is the value of the token  */
};

#line 8 "/home/alexander/Web/alexander/aCMS/aCMS-base/classes/ConfigurationFileParser/ConfigurationFileParser.y"

	// Include AOF error class for exceptions
	require_once(dirname(__FILE__) . '/' . "../AOF/AOFError.class.php");

	// Include lexer
	require_once(dirname(__FILE__) . '/' . "ConfigurationFileLexer.class.php");


	/**
	 * The exception class for all parser and lexer error during parsing
	 */
	class ConfigurationFileParserError extends AOFError {
		public function __construct($parser, $lexer) {
			$token = $parser->yyTokenName[$lexer->get_token()];
			$line  = $lexer->get_line();
			$offset= $lexer->get_counter();
			
			parent::__construct(
			  "Syntax error: Unexpected {$token} (Line {$line}, Offset {$offset})");
		}
	}
#line 99 "/home/alexander/Web/alexander/aCMS/aCMS-base/classes/ConfigurationFileParser/ConfigurationFileParser.php"

#line 32 "/home/alexander/Web/alexander/aCMS/aCMS-base/classes/ConfigurationFileParser/ConfigurationFileParser.y"
class ConfigurationFileParser#line 103 "/home/alexander/Web/alexander/aCMS/aCMS-base/classes/ConfigurationFileParser/ConfigurationFileParser.php"
{
#line 34 "/home/alexander/Web/alexander/aCMS/aCMS-base/classes/ConfigurationFileParser/ConfigurationFileParser.y"

	protected $lexer;
	protected $result   = array();
	protected $retvalue = 0;
	protected $section  = null;
	
	
	/**
	 * 
	 */
    public function __construct() {}
	
	
	public function process($input) {
		// Read open file objects
		if(is_resource($input)) {
			$stat = fstat($input);
			$input = fread($input, $stat['size']);
		}
		
		// Initialize lexer
		$this->lexer = new ConfigurationFileLexer($input);
		
		// Reset all internal variables
		$this->result   = array();
		$this->retvalue = 0;
		$this->section  = null;
		
		
		$this->current_section = null;
		
		// Do parsing process
		while($this->lexer->yylex()) {
			$this->doParse($this->lexer->get_token(), $this->lexer->get_value());
		}
		// Finalize parsing process
		$this->doParse(0, 0);
		
		return $this->result;
	}
#line 147 "/home/alexander/Web/alexander/aCMS/aCMS-base/classes/ConfigurationFileParser/ConfigurationFileParser.php"

    const TOK_COMMENT                        =  1;
    const TOK_COMA                           =  2;
    const TOK_EQUALS                         =  3;
    const TOK_SQBRACKETOPEN                  =  4;
    const TOK_SQBRACKETCLOSE                 =  5;
    const TOK_BOOLTRUE                       =  6;
    const TOK_BOOLFALSE                      =  7;
    const TOK_FLOAT                          =  8;
    const TOK_INTEGER                        =  9;
    const TOK_STRING                         = 10;
    const TOK_OTHER                          = 11;
    const TOK_NAME                           = 12;
    const TOK_EOL                            = 13;
    const YY_NO_ACTION = 52;
    const YY_ACCEPT_ACTION = 51;
    const YY_ERROR_ACTION = 50;

    const YY_SZ_ACTTAB = 49;
static public $yy_action = array(
 /*     0 */     1,   17,   22,   23,   26,   25,   18,   15,   27,    1,
 /*    10 */    24,   22,   23,   26,   25,   18,   15,   27,    1,   21,
 /*    20 */    22,   23,   26,   25,   18,   15,   27,   13,   14,   13,
 /*    30 */    10,   11,   10,   51,    4,    7,   12,    8,    6,   35,
 /*    40 */     6,    5,    2,    3,   20,   16,   44,    9,   19,
    );
    static public $yy_lookahead = array(
 /*     0 */     4,    5,    6,    7,    8,    9,   10,   11,   12,    4,
 /*    10 */     5,    6,    7,    8,    9,   10,   11,   12,    4,   13,
 /*    20 */     6,    7,    8,    9,   10,   11,   12,    1,   13,    1,
 /*    30 */     4,   12,    4,   15,   16,   17,    2,   17,   12,   13,
 /*    40 */    12,   18,   19,    3,    5,    2,   20,   18,   18,
);
    const YY_SHIFT_USE_DFLT = -5;
    const YY_SHIFT_MAX = 11;
    static public $yy_shift_ofst = array(
 /*     0 */    28,   -4,    5,   14,   26,   43,   40,   15,    6,   34,
 /*    10 */    19,   39,
);
    const YY_REDUCE_USE_DFLT = -1;
    const YY_REDUCE_MAX = 4;
    static public $yy_reduce_ofst = array(
 /*     0 */    18,   23,   29,   30,   20,
);
    static public $yyExpectedTokens = array(
        /* 0 */ array(1, 4, 12, ),
        /* 1 */ array(4, 5, 6, 7, 8, 9, 10, 11, 12, ),
        /* 2 */ array(4, 5, 6, 7, 8, 9, 10, 11, 12, ),
        /* 3 */ array(4, 6, 7, 8, 9, 10, 11, 12, ),
        /* 4 */ array(1, 4, 12, 13, ),
        /* 5 */ array(2, ),
        /* 6 */ array(3, ),
        /* 7 */ array(13, ),
        /* 8 */ array(13, ),
        /* 9 */ array(2, ),
        /* 10 */ array(12, ),
        /* 11 */ array(5, ),
        /* 12 */ array(),
        /* 13 */ array(),
        /* 14 */ array(),
        /* 15 */ array(),
        /* 16 */ array(),
        /* 17 */ array(),
        /* 18 */ array(),
        /* 19 */ array(),
        /* 20 */ array(),
        /* 21 */ array(),
        /* 22 */ array(),
        /* 23 */ array(),
        /* 24 */ array(),
        /* 25 */ array(),
        /* 26 */ array(),
        /* 27 */ array(),
);
    static public $yy_default = array(
 /*     0 */    35,   50,   50,   50,   28,   47,   50,   30,   32,   49,
 /*    10 */    50,   50,   48,   36,   29,   45,   46,   43,   41,   34,
 /*    20 */    33,   31,   37,   38,   42,   40,   39,   44,
);
    const YYNOCODE = 21;
    const YYSTACKDEPTH = 100;
    const YYNSTATE = 28;
    const YYNRULE = 22;
    const YYERRORSYMBOL = 14;
    const YYERRSYMDT = 'yy0';
    const YYFALLBACK = 1;
    static public $yyFallback = array(
    0,  /*          $ => nothing */
    0,  /*    COMMENT => nothing */
    1,  /*       COMA => COMMENT */
    1,  /*     EQUALS => COMMENT */
    1,  /* SQBRACKETOPEN => COMMENT */
    1,  /* SQBRACKETCLOSE => COMMENT */
    1,  /*   BOOLTRUE => COMMENT */
    1,  /*  BOOLFALSE => COMMENT */
    1,  /*      FLOAT => COMMENT */
    1,  /*    INTEGER => COMMENT */
    1,  /*     STRING => COMMENT */
    1,  /*      OTHER => COMMENT */
    1,  /*       NAME => COMMENT */
    0,  /*        EOL => nothing */
    );
    static function Trace($TraceFILE, $zTracePrompt)
    {
        if (!$TraceFILE) {
            $zTracePrompt = 0;
        } elseif (!$zTracePrompt) {
            $TraceFILE = 0;
        }
        self::$yyTraceFILE = $TraceFILE;
        self::$yyTracePrompt = $zTracePrompt;
    }

    static function PrintTrace()
    {
        self::$yyTraceFILE = fopen('php://output', 'w');
        self::$yyTracePrompt = '<br>';
    }

    static public $yyTraceFILE;
    static public $yyTracePrompt;
    public $yyidx;                    /* Index of top element in stack */
    public $yyerrcnt;                 /* Shifts left before out of the error */
    public $yystack = array();  /* The parser's stack */

    public $yyTokenName = array( 
  '$',             'COMMENT',       'COMA',          'EQUALS',      
  'SQBRACKETOPEN',  'SQBRACKETCLOSE',  'BOOLTRUE',      'BOOLFALSE',   
  'FLOAT',         'INTEGER',       'STRING',        'OTHER',       
  'NAME',          'EOL',           'error',         'start',       
  'loop',          'line',          'value',         'value_list',  
    );

    static public $yyRuleName = array(
 /*   0 */ "start ::= loop",
 /*   1 */ "loop ::= line EOL",
 /*   2 */ "loop ::= line",
 /*   3 */ "loop ::= loop line EOL",
 /*   4 */ "loop ::= loop line",
 /*   5 */ "line ::= SQBRACKETOPEN NAME SQBRACKETCLOSE",
 /*   6 */ "line ::= NAME EQUALS value",
 /*   7 */ "line ::=",
 /*   8 */ "line ::= COMMENT",
 /*   9 */ "value ::= BOOLTRUE",
 /*  10 */ "value ::= BOOLFALSE",
 /*  11 */ "value ::= FLOAT",
 /*  12 */ "value ::= INTEGER",
 /*  13 */ "value ::= STRING",
 /*  14 */ "value ::= SQBRACKETOPEN value_list SQBRACKETCLOSE",
 /*  15 */ "value ::= SQBRACKETOPEN SQBRACKETCLOSE",
 /*  16 */ "value ::= NAME",
 /*  17 */ "value ::= OTHER",
 /*  18 */ "value_list ::= value COMA",
 /*  19 */ "value_list ::= value",
 /*  20 */ "value_list ::= value_list value COMA",
 /*  21 */ "value_list ::= value_list value",
    );

    function tokenName($tokenType)
    {
        if ($tokenType === 0) {
            return 'End of Input';
        }
        if ($tokenType > 0 && $tokenType < count($this->yyTokenName)) {
            return $this->yyTokenName[$tokenType];
        } else {
            return "Unknown";
        }
    }

    static function yy_destructor($yymajor, $yypminor)
    {
        switch ($yymajor) {
            default:  break;   /* If no destructor action specified: do nothing */
        }
    }

    function yy_pop_parser_stack()
    {
        if (!count($this->yystack)) {
            return;
        }
        $yytos = array_pop($this->yystack);
        if (self::$yyTraceFILE && $this->yyidx >= 0) {
            fwrite(self::$yyTraceFILE,
                self::$yyTracePrompt . 'Popping ' . $this->yyTokenName[$yytos->major] .
                    "\n");
        }
        $yymajor = $yytos->major;
        self::yy_destructor($yymajor, $yytos->minor);
        $this->yyidx--;
        return $yymajor;
    }

    function __destruct()
    {
        while ($this->yystack !== Array()) {
            $this->yy_pop_parser_stack();
        }
        if (is_resource(self::$yyTraceFILE)) {
            fclose(self::$yyTraceFILE);
        }
    }

    function yy_get_expected_tokens($token)
    {
        $state = $this->yystack[$this->yyidx]->stateno;
        $expected = self::$yyExpectedTokens[$state];
        if (in_array($token, self::$yyExpectedTokens[$state], true)) {
            return $expected;
        }
        $stack = $this->yystack;
        $yyidx = $this->yyidx;
        do {
            $yyact = $this->yy_find_shift_action($token);
            if ($yyact >= self::YYNSTATE && $yyact < self::YYNSTATE + self::YYNRULE) {
                // reduce action
                $done = 0;
                do {
                    if ($done++ == 100) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // too much recursion prevents proper detection
                        // so give up
                        return array_unique($expected);
                    }
                    $yyruleno = $yyact - self::YYNSTATE;
                    $this->yyidx -= self::$yyRuleInfo[$yyruleno]['rhs'];
                    $nextstate = $this->yy_find_reduce_action(
                        $this->yystack[$this->yyidx]->stateno,
                        self::$yyRuleInfo[$yyruleno]['lhs']);
                    if (isset(self::$yyExpectedTokens[$nextstate])) {
		        $expected = array_merge($expected, self::$yyExpectedTokens[$nextstate]);
                            if (in_array($token,
                                  self::$yyExpectedTokens[$nextstate], true)) {
                            $this->yyidx = $yyidx;
                            $this->yystack = $stack;
                            return array_unique($expected);
                        }
                    }
                    if ($nextstate < self::YYNSTATE) {
                        // we need to shift a non-terminal
                        $this->yyidx++;
                        $x = new ConfigurationFileParser_yyStackEntry;
                        $x->stateno = $nextstate;
                        $x->major = self::$yyRuleInfo[$yyruleno]['lhs'];
                        $this->yystack[$this->yyidx] = $x;
                        continue 2;
                    } elseif ($nextstate == self::YYNSTATE + self::YYNRULE + 1) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // the last token was just ignored, we can't accept
                        // by ignoring input, this is in essence ignoring a
                        // syntax error!
                        return array_unique($expected);
                    } elseif ($nextstate === self::YY_NO_ACTION) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // input accepted, but not shifted (I guess)
                        return $expected;
                    } else {
                        $yyact = $nextstate;
                    }
                } while (true);
            }
            break;
        } while (true);
	$this->yyidx = $yyidx;
	$this->yystack = $stack;
        return array_unique($expected);
    }

    function yy_is_expected_token($token)
    {
        if ($token === 0) {
            return true; // 0 is not part of this
        }
        $state = $this->yystack[$this->yyidx]->stateno;
        if (in_array($token, self::$yyExpectedTokens[$state], true)) {
            return true;
        }
        $stack = $this->yystack;
        $yyidx = $this->yyidx;
        do {
            $yyact = $this->yy_find_shift_action($token);
            if ($yyact >= self::YYNSTATE && $yyact < self::YYNSTATE + self::YYNRULE) {
                // reduce action
                $done = 0;
                do {
                    if ($done++ == 100) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // too much recursion prevents proper detection
                        // so give up
                        return true;
                    }
                    $yyruleno = $yyact - self::YYNSTATE;
                    $this->yyidx -= self::$yyRuleInfo[$yyruleno]['rhs'];
                    $nextstate = $this->yy_find_reduce_action(
                        $this->yystack[$this->yyidx]->stateno,
                        self::$yyRuleInfo[$yyruleno]['lhs']);
                    if (isset(self::$yyExpectedTokens[$nextstate]) &&
                          in_array($token, self::$yyExpectedTokens[$nextstate], true)) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        return true;
                    }
                    if ($nextstate < self::YYNSTATE) {
                        // we need to shift a non-terminal
                        $this->yyidx++;
                        $x = new ConfigurationFileParser_yyStackEntry;
                        $x->stateno = $nextstate;
                        $x->major = self::$yyRuleInfo[$yyruleno]['lhs'];
                        $this->yystack[$this->yyidx] = $x;
                        continue 2;
                    } elseif ($nextstate == self::YYNSTATE + self::YYNRULE + 1) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        if (!$token) {
                            // end of input: this is valid
                            return true;
                        }
                        // the last token was just ignored, we can't accept
                        // by ignoring input, this is in essence ignoring a
                        // syntax error!
                        return false;
                    } elseif ($nextstate === self::YY_NO_ACTION) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // input accepted, but not shifted (I guess)
                        return true;
                    } else {
                        $yyact = $nextstate;
                    }
                } while (true);
            }
            break;
        } while (true);
        $this->yyidx = $yyidx;
        $this->yystack = $stack;
        return true;
    }

   function yy_find_shift_action($iLookAhead)
    {
        $stateno = $this->yystack[$this->yyidx]->stateno;
     
        /* if ($this->yyidx < 0) return self::YY_NO_ACTION;  */
        if (!isset(self::$yy_shift_ofst[$stateno])) {
            // no shift actions
            return self::$yy_default[$stateno];
        }
        $i = self::$yy_shift_ofst[$stateno];
        if ($i === self::YY_SHIFT_USE_DFLT) {
            return self::$yy_default[$stateno];
        }
        if ($iLookAhead == self::YYNOCODE) {
            return self::YY_NO_ACTION;
        }
        $i += $iLookAhead;
        if ($i < 0 || $i >= self::YY_SZ_ACTTAB ||
              self::$yy_lookahead[$i] != $iLookAhead) {
            if (count(self::$yyFallback) && $iLookAhead < count(self::$yyFallback)
                   && ($iFallback = self::$yyFallback[$iLookAhead]) != 0) {
                if (self::$yyTraceFILE) {
                    fwrite(self::$yyTraceFILE, self::$yyTracePrompt . "FALLBACK " .
                        $this->yyTokenName[$iLookAhead] . " => " .
                        $this->yyTokenName[$iFallback] . "\n");
                }
                return $this->yy_find_shift_action($iFallback);
            }
            return self::$yy_default[$stateno];
        } else {
            return self::$yy_action[$i];
        }
    }

    function yy_find_reduce_action($stateno, $iLookAhead)
    {
        /* $stateno = $this->yystack[$this->yyidx]->stateno; */

        if (!isset(self::$yy_reduce_ofst[$stateno])) {
            return self::$yy_default[$stateno];
        }
        $i = self::$yy_reduce_ofst[$stateno];
        if ($i == self::YY_REDUCE_USE_DFLT) {
            return self::$yy_default[$stateno];
        }
        if ($iLookAhead == self::YYNOCODE) {
            return self::YY_NO_ACTION;
        }
        $i += $iLookAhead;
        if ($i < 0 || $i >= self::YY_SZ_ACTTAB ||
              self::$yy_lookahead[$i] != $iLookAhead) {
            return self::$yy_default[$stateno];
        } else {
            return self::$yy_action[$i];
        }
    }

    function yy_shift($yyNewState, $yyMajor, $yypMinor)
    {
        $this->yyidx++;
        if ($this->yyidx >= self::YYSTACKDEPTH) {
            $this->yyidx--;
            if (self::$yyTraceFILE) {
                fprintf(self::$yyTraceFILE, "%sStack Overflow!\n", self::$yyTracePrompt);
            }
            while ($this->yyidx >= 0) {
                $this->yy_pop_parser_stack();
            }
            return;
        }
        $yytos = new ConfigurationFileParser_yyStackEntry;
        $yytos->stateno = $yyNewState;
        $yytos->major = $yyMajor;
        $yytos->minor = $yypMinor;
        array_push($this->yystack, $yytos);
        if (self::$yyTraceFILE && $this->yyidx > 0) {
            fprintf(self::$yyTraceFILE, "%sShift %d\n", self::$yyTracePrompt,
                $yyNewState);
            fprintf(self::$yyTraceFILE, "%sStack:", self::$yyTracePrompt);
            for($i = 1; $i <= $this->yyidx; $i++) {
                fprintf(self::$yyTraceFILE, " %s",
                    $this->yyTokenName[$this->yystack[$i]->major]);
            }
            fwrite(self::$yyTraceFILE,"\n");
        }
    }

    static public $yyRuleInfo = array(
  array( 'lhs' => 15, 'rhs' => 1 ),
  array( 'lhs' => 16, 'rhs' => 2 ),
  array( 'lhs' => 16, 'rhs' => 1 ),
  array( 'lhs' => 16, 'rhs' => 3 ),
  array( 'lhs' => 16, 'rhs' => 2 ),
  array( 'lhs' => 17, 'rhs' => 3 ),
  array( 'lhs' => 17, 'rhs' => 3 ),
  array( 'lhs' => 17, 'rhs' => 0 ),
  array( 'lhs' => 17, 'rhs' => 1 ),
  array( 'lhs' => 18, 'rhs' => 1 ),
  array( 'lhs' => 18, 'rhs' => 1 ),
  array( 'lhs' => 18, 'rhs' => 1 ),
  array( 'lhs' => 18, 'rhs' => 1 ),
  array( 'lhs' => 18, 'rhs' => 1 ),
  array( 'lhs' => 18, 'rhs' => 3 ),
  array( 'lhs' => 18, 'rhs' => 2 ),
  array( 'lhs' => 18, 'rhs' => 1 ),
  array( 'lhs' => 18, 'rhs' => 1 ),
  array( 'lhs' => 19, 'rhs' => 2 ),
  array( 'lhs' => 19, 'rhs' => 1 ),
  array( 'lhs' => 19, 'rhs' => 3 ),
  array( 'lhs' => 19, 'rhs' => 2 ),
    );

    static public $yyReduceMap = array(
        0 => 0,
        2 => 0,
        1 => 1,
        14 => 1,
        3 => 3,
        4 => 4,
        5 => 5,
        6 => 6,
        7 => 7,
        8 => 7,
        9 => 9,
        10 => 10,
        11 => 11,
        12 => 12,
        13 => 13,
        15 => 15,
        16 => 16,
        17 => 16,
        18 => 18,
        19 => 19,
        20 => 20,
        21 => 21,
    );
#line 94 "/home/alexander/Web/alexander/aCMS/aCMS-base/classes/ConfigurationFileParser/ConfigurationFileParser.y"
    function yy_r0(){
	$this->_retvalue = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 633 "/home/alexander/Web/alexander/aCMS/aCMS-base/classes/ConfigurationFileParser/ConfigurationFileParser.php"
#line 103 "/home/alexander/Web/alexander/aCMS/aCMS-base/classes/ConfigurationFileParser/ConfigurationFileParser.y"
    function yy_r1(){
	$this->_retvalue = $this->yystack[$this->yyidx + -1]->minor;
    }
#line 638 "/home/alexander/Web/alexander/aCMS/aCMS-base/classes/ConfigurationFileParser/ConfigurationFileParser.php"
#line 110 "/home/alexander/Web/alexander/aCMS/aCMS-base/classes/ConfigurationFileParser/ConfigurationFileParser.y"
    function yy_r3(){
	$this->_retvalue = $this->yystack[$this->yyidx + -2]->minor . $this->yystack[$this->yyidx + -1]->minor;
    }
#line 643 "/home/alexander/Web/alexander/aCMS/aCMS-base/classes/ConfigurationFileParser/ConfigurationFileParser.php"
#line 113 "/home/alexander/Web/alexander/aCMS/aCMS-base/classes/ConfigurationFileParser/ConfigurationFileParser.y"
    function yy_r4(){
	$this->_retvalue = $this->yystack[$this->yyidx + -1]->minor . $this->yystack[$this->yyidx + 0]->minor;
    }
#line 648 "/home/alexander/Web/alexander/aCMS/aCMS-base/classes/ConfigurationFileParser/ConfigurationFileParser.php"
#line 122 "/home/alexander/Web/alexander/aCMS/aCMS-base/classes/ConfigurationFileParser/ConfigurationFileParser.y"
    function yy_r5(){
	$this->section = $this->yystack[$this->yyidx + -1]->minor;
	
	$this->_retvalue = '';
    }
#line 655 "/home/alexander/Web/alexander/aCMS/aCMS-base/classes/ConfigurationFileParser/ConfigurationFileParser.php"
#line 128 "/home/alexander/Web/alexander/aCMS/aCMS-base/classes/ConfigurationFileParser/ConfigurationFileParser.y"
    function yy_r6(){
	if($this->section === null) {
		if(!isset($this->result["DEFAULT"])) {
			$this->result["DEFAULT"] = array();
		}
		
		$this->result["DEFAULT"][$this->yystack[$this->yyidx + -2]->minor] = $this->yystack[$this->yyidx + 0]->minor;
	} else {
		if(!isset($this->result[$this->section])) {
			$this->result[$this->section] = array();
		}
		
		$this->result[$this->section][$this->yystack[$this->yyidx + -2]->minor] = $this->yystack[$this->yyidx + 0]->minor;
	}
	
	$this->_retvalue = '';
    }
#line 674 "/home/alexander/Web/alexander/aCMS/aCMS-base/classes/ConfigurationFileParser/ConfigurationFileParser.php"
#line 146 "/home/alexander/Web/alexander/aCMS/aCMS-base/classes/ConfigurationFileParser/ConfigurationFileParser.y"
    function yy_r7(){
	$this->_retvalue = '';
    }
#line 679 "/home/alexander/Web/alexander/aCMS/aCMS-base/classes/ConfigurationFileParser/ConfigurationFileParser.php"
#line 159 "/home/alexander/Web/alexander/aCMS/aCMS-base/classes/ConfigurationFileParser/ConfigurationFileParser.y"
    function yy_r9(){
	$this->_retvalue = true;
    }
#line 684 "/home/alexander/Web/alexander/aCMS/aCMS-base/classes/ConfigurationFileParser/ConfigurationFileParser.php"
#line 163 "/home/alexander/Web/alexander/aCMS/aCMS-base/classes/ConfigurationFileParser/ConfigurationFileParser.y"
    function yy_r10(){
	$this->_retvalue = false;
    }
#line 689 "/home/alexander/Web/alexander/aCMS/aCMS-base/classes/ConfigurationFileParser/ConfigurationFileParser.php"
#line 167 "/home/alexander/Web/alexander/aCMS/aCMS-base/classes/ConfigurationFileParser/ConfigurationFileParser.y"
    function yy_r11(){
	$this->_retvalue = floatval($this->yystack[$this->yyidx + 0]->minor);
    }
#line 694 "/home/alexander/Web/alexander/aCMS/aCMS-base/classes/ConfigurationFileParser/ConfigurationFileParser.php"
#line 171 "/home/alexander/Web/alexander/aCMS/aCMS-base/classes/ConfigurationFileParser/ConfigurationFileParser.y"
    function yy_r12(){
	$this->_retvalue = intval($this->yystack[$this->yyidx + 0]->minor);
    }
#line 699 "/home/alexander/Web/alexander/aCMS/aCMS-base/classes/ConfigurationFileParser/ConfigurationFileParser.php"
#line 175 "/home/alexander/Web/alexander/aCMS/aCMS-base/classes/ConfigurationFileParser/ConfigurationFileParser.y"
    function yy_r13(){
	$this->_retvalue = substr($this->yystack[$this->yyidx + 0]->minor, 1, -1);
    }
#line 704 "/home/alexander/Web/alexander/aCMS/aCMS-base/classes/ConfigurationFileParser/ConfigurationFileParser.php"
#line 183 "/home/alexander/Web/alexander/aCMS/aCMS-base/classes/ConfigurationFileParser/ConfigurationFileParser.y"
    function yy_r15(){
	$this->_retvalue = array();
    }
#line 709 "/home/alexander/Web/alexander/aCMS/aCMS-base/classes/ConfigurationFileParser/ConfigurationFileParser.php"
#line 187 "/home/alexander/Web/alexander/aCMS/aCMS-base/classes/ConfigurationFileParser/ConfigurationFileParser.y"
    function yy_r16(){
	$this->_retvalue = trim($this->yystack[$this->yyidx + 0]->minor);
    }
#line 714 "/home/alexander/Web/alexander/aCMS/aCMS-base/classes/ConfigurationFileParser/ConfigurationFileParser.php"
#line 198 "/home/alexander/Web/alexander/aCMS/aCMS-base/classes/ConfigurationFileParser/ConfigurationFileParser.y"
    function yy_r18(){
	$this->_retvalue = array($this->yystack[$this->yyidx + -1]->minor);
    }
#line 719 "/home/alexander/Web/alexander/aCMS/aCMS-base/classes/ConfigurationFileParser/ConfigurationFileParser.php"
#line 201 "/home/alexander/Web/alexander/aCMS/aCMS-base/classes/ConfigurationFileParser/ConfigurationFileParser.y"
    function yy_r19(){
	$this->_retvalue = array($this->yystack[$this->yyidx + 0]->minor);
    }
#line 724 "/home/alexander/Web/alexander/aCMS/aCMS-base/classes/ConfigurationFileParser/ConfigurationFileParser.php"
#line 204 "/home/alexander/Web/alexander/aCMS/aCMS-base/classes/ConfigurationFileParser/ConfigurationFileParser.y"
    function yy_r20(){
	$this->_retvalue = array_merge($this->yystack[$this->yyidx + -2]->minor, array($this->yystack[$this->yyidx + -1]->minor));
    }
#line 729 "/home/alexander/Web/alexander/aCMS/aCMS-base/classes/ConfigurationFileParser/ConfigurationFileParser.php"
#line 207 "/home/alexander/Web/alexander/aCMS/aCMS-base/classes/ConfigurationFileParser/ConfigurationFileParser.y"
    function yy_r21(){
	$this->_retvalue = array_merge($this->yystack[$this->yyidx + -1]->minor, array($this->yystack[$this->yyidx + 0]->minor));
    }
#line 734 "/home/alexander/Web/alexander/aCMS/aCMS-base/classes/ConfigurationFileParser/ConfigurationFileParser.php"

    private $_retvalue;

    function yy_reduce($yyruleno)
    {
        $yymsp = $this->yystack[$this->yyidx];
        if (self::$yyTraceFILE && $yyruleno >= 0 
              && $yyruleno < count(self::$yyRuleName)) {
            fprintf(self::$yyTraceFILE, "%sReduce (%d) [%s].\n",
                self::$yyTracePrompt, $yyruleno,
                self::$yyRuleName[$yyruleno]);
        }

        $this->_retvalue = $yy_lefthand_side = null;
        if (array_key_exists($yyruleno, self::$yyReduceMap)) {
            // call the action
            $this->_retvalue = null;
            $this->{'yy_r' . self::$yyReduceMap[$yyruleno]}();
            $yy_lefthand_side = $this->_retvalue;
        }
        $yygoto = self::$yyRuleInfo[$yyruleno]['lhs'];
        $yysize = self::$yyRuleInfo[$yyruleno]['rhs'];
        $this->yyidx -= $yysize;
        for($i = $yysize; $i; $i--) {
            // pop all of the right-hand side parameters
            array_pop($this->yystack);
        }
        $yyact = $this->yy_find_reduce_action($this->yystack[$this->yyidx]->stateno, $yygoto);
        if ($yyact < self::YYNSTATE) {
            if (!self::$yyTraceFILE && $yysize) {
                $this->yyidx++;
                $x = new ConfigurationFileParser_yyStackEntry;
                $x->stateno = $yyact;
                $x->major = $yygoto;
                $x->minor = $yy_lefthand_side;
                $this->yystack[$this->yyidx] = $x;
            } else {
                $this->yy_shift($yyact, $yygoto, $yy_lefthand_side);
            }
        } elseif ($yyact == self::YYNSTATE + self::YYNRULE + 1) {
            $this->yy_accept();
        }
    }

    function yy_parse_failed()
    {
        if (self::$yyTraceFILE) {
            fprintf(self::$yyTraceFILE, "%sFail!\n", self::$yyTracePrompt);
        }
        while ($this->yyidx >= 0) {
            $this->yy_pop_parser_stack();
        }
    }

    function yy_syntax_error($yymajor, $TOKEN)
    {
#line 84 "/home/alexander/Web/alexander/aCMS/aCMS-base/classes/ConfigurationFileParser/ConfigurationFileParser.y"

	throw new ConfigurationFileParserError($this, $this->lexer);
#line 795 "/home/alexander/Web/alexander/aCMS/aCMS-base/classes/ConfigurationFileParser/ConfigurationFileParser.php"
    }

    function yy_accept()
    {
        if (self::$yyTraceFILE) {
            fprintf(self::$yyTraceFILE, "%sAccept!\n", self::$yyTracePrompt);
        }
        while ($this->yyidx >= 0) {
            $stack = $this->yy_pop_parser_stack();
        }
#line 79 "/home/alexander/Web/alexander/aCMS/aCMS-base/classes/ConfigurationFileParser/ConfigurationFileParser.y"

	$this->retvalue = $this->_retvalue;
#line 810 "/home/alexander/Web/alexander/aCMS/aCMS-base/classes/ConfigurationFileParser/ConfigurationFileParser.php"
    }

    function doParse($yymajor, $yytokenvalue)
    {
        $yyerrorhit = 0;   /* True if yymajor has invoked an error */
        
        if ($this->yyidx === null || $this->yyidx < 0) {
            $this->yyidx = 0;
            $this->yyerrcnt = -1;
            $x = new ConfigurationFileParser_yyStackEntry;
            $x->stateno = 0;
            $x->major = 0;
            $this->yystack = array();
            array_push($this->yystack, $x);
        }
        $yyendofinput = ($yymajor==0);
        
        if (self::$yyTraceFILE) {
            fprintf(self::$yyTraceFILE, "%sInput %s\n",
                self::$yyTracePrompt, $this->yyTokenName[$yymajor]);
        }
        
        do {
            $yyact = $this->yy_find_shift_action($yymajor);
            if ($yymajor < self::YYERRORSYMBOL &&
                  !$this->yy_is_expected_token($yymajor)) {
                // force a syntax error
                $yyact = self::YY_ERROR_ACTION;
            }
            if ($yyact < self::YYNSTATE) {
                $this->yy_shift($yyact, $yymajor, $yytokenvalue);
                $this->yyerrcnt--;
                if ($yyendofinput && $this->yyidx >= 0) {
                    $yymajor = 0;
                } else {
                    $yymajor = self::YYNOCODE;
                }
            } elseif ($yyact < self::YYNSTATE + self::YYNRULE) {
                $this->yy_reduce($yyact - self::YYNSTATE);
            } elseif ($yyact == self::YY_ERROR_ACTION) {
                if (self::$yyTraceFILE) {
                    fprintf(self::$yyTraceFILE, "%sSyntax Error!\n",
                        self::$yyTracePrompt);
                }
                if (self::YYERRORSYMBOL) {
                    if ($this->yyerrcnt < 0) {
                        $this->yy_syntax_error($yymajor, $yytokenvalue);
                    }
                    $yymx = $this->yystack[$this->yyidx]->major;
                    if ($yymx == self::YYERRORSYMBOL || $yyerrorhit ){
                        if (self::$yyTraceFILE) {
                            fprintf(self::$yyTraceFILE, "%sDiscard input token %s\n",
                                self::$yyTracePrompt, $this->yyTokenName[$yymajor]);
                        }
                        $this->yy_destructor($yymajor, $yytokenvalue);
                        $yymajor = self::YYNOCODE;
                    } else {
                        while ($this->yyidx >= 0 &&
                                 $yymx != self::YYERRORSYMBOL &&
        ($yyact = $this->yy_find_shift_action(self::YYERRORSYMBOL)) >= self::YYNSTATE
                              ){
                            $this->yy_pop_parser_stack();
                        }
                        if ($this->yyidx < 0 || $yymajor==0) {
                            $this->yy_destructor($yymajor, $yytokenvalue);
                            $this->yy_parse_failed();
                            $yymajor = self::YYNOCODE;
                        } elseif ($yymx != self::YYERRORSYMBOL) {
                            $u2 = 0;
                            $this->yy_shift($yyact, self::YYERRORSYMBOL, $u2);
                        }
                    }
                    $this->yyerrcnt = 3;
                    $yyerrorhit = 1;
                } else {
                    if ($this->yyerrcnt <= 0) {
                        $this->yy_syntax_error($yymajor, $yytokenvalue);
                    }
                    $this->yyerrcnt = 3;
                    $this->yy_destructor($yymajor, $yytokenvalue);
                    if ($yyendofinput) {
                        $this->yy_parse_failed();
                    }
                    $yymajor = self::YYNOCODE;
                }
            } else {
                $this->yy_accept();
                $yymajor = self::YYNOCODE;
            }            
        } while ($yymajor != self::YYNOCODE && $this->yyidx >= 0);
    }
}
