<?php
	/**
	 * The configuration lexer class
	 * 
	 * @package aCMS
	 * @author Alexander Schlarb
	 */
	
	class ConfigurationFileLexer {
		protected $counter = 0;
		protected $input;
		protected $line = 1;
		protected $token;
		protected $value;
		
		
		public function __construct($lexinput) {
			$this->input = $lexinput;
		}
		
		
		public function get_counter() {
			return $this->counter;
		}
		
		
		public function get_line() {
			return $this->line;
		}
		
		
		public function get_token() {
			return $this->token;
		}
		
		
		public function get_value() {
			return $this->value;
		}
		
		
		protected function get_token_value($name) {
			return constant("ConfigurationFileParser::TOK_{$name}");
		}


    private $_yy_state = 1;
    private $_yy_stack = array();

    function yylex()
    {
        return $this->{'yylex' . $this->_yy_state}();
    }

    function yypushstate($state)
    {
        array_push($this->_yy_stack, $this->_yy_state);
        $this->_yy_state = $state;
    }

    function yypopstate()
    {
        $this->_yy_state = array_pop($this->_yy_stack);
    }

    function yybegin($state)
    {
        $this->_yy_state = $state;
    }



    function yylex1()
    {
        $tokenMap = array (
              1 => 0,
              2 => 0,
              3 => 0,
              4 => 0,
              5 => 0,
              6 => 0,
              7 => 0,
              8 => 0,
              9 => 0,
              10 => 0,
              11 => 0,
              12 => 0,
              13 => 0,
            );
        if ($this->counter >= strlen($this->input)) {
            return false; // end of input
        }
        $yy_global_pattern = "/^((?:\\s*[;#](?:[^\r\n]*)*))|^((?:\\s*,\\s*))|^((?:\n|\r\n))|^((?:\\s*=\\s*))|^((?:\\s*\\[\\s*))|^((?:\\s*\\]\\s*))|^((?:[Tt][Rr][Uu][Ee]|[Oo][Nn]|[Yy][Ee][Ss]))|^((?:[Ff][Aa][Ll][Ss][Ee]|[Oo][Ff][Ff]|[Nn][Oo]))|^(\\d+\\.\\d+(?:[Ee][\-+]\\d+)?)|^(\\d+)|^(\"(?:[^\"]*)*\"|'(?:[^']*)*')|^([\w._*]+)|^([^\r\n]+)/iS";

        do {
            if (preg_match($yy_global_pattern, substr($this->input, $this->counter), $yymatches)) {
                $yysubmatches = $yymatches;
                $yymatches = array_filter($yymatches, 'strlen'); // remove empty sub-patterns
                if (!count($yymatches)) {
                    throw new Exception('Error: lexing failed because a rule matched' .
                        'an empty string.  Input "' . substr($this->input,
                        $this->counter, 5) . '... state START');
                }
                next($yymatches); // skip global match
                $this->token = key($yymatches); // token number
                if ($tokenMap[$this->token]) {
                    // extract sub-patterns for passing to lex function
                    $yysubmatches = array_slice($yysubmatches, $this->token + 1,
                        $tokenMap[$this->token]);
                } else {
                    $yysubmatches = array();
                }
                $this->value = current($yymatches); // token value
                $r = $this->{'yy_r1_' . $this->token}($yysubmatches);
                if ($r === null) {
                    $this->counter += strlen($this->value);
                    $this->line += substr_count($this->value, "\n");
                    // accept this token
                    return true;
                } elseif ($r === true) {
                    // we have changed state
                    // process this token in the new state
                    return $this->yylex();
                } elseif ($r === false) {
                    $this->counter += strlen($this->value);
                    $this->line += substr_count($this->value, "\n");
                    if ($this->counter >= strlen($this->input)) {
                        return false; // end of input
                    }
                    // skip this token
                    continue;
                }            } else {
                throw new Exception('Unexpected input at line' . $this->line .
                    ': ' . $this->input[$this->counter]);
            }
            break;
        } while (true);

    } // end function


    const START = 1;
    function yy_r1_1($yy_subpatterns)
    {

	$this->token = $this->get_token_value('COMMENT');
    }
    function yy_r1_2($yy_subpatterns)
    {

	$this->token = $this->get_token_value('COMA');
    }
    function yy_r1_3($yy_subpatterns)
    {

	$this->token = $this->get_token_value('EOL');
    }
    function yy_r1_4($yy_subpatterns)
    {

	$this->token = $this->get_token_value('EQUALS');
    }
    function yy_r1_5($yy_subpatterns)
    {

	$this->token = $this->get_token_value('SQBRACKETOPEN');
    }
    function yy_r1_6($yy_subpatterns)
    {

	$this->token = $this->get_token_value('SQBRACKETCLOSE');
    }
    function yy_r1_7($yy_subpatterns)
    {

	$this->token = $this->get_token_value('BOOLTRUE');
    }
    function yy_r1_8($yy_subpatterns)
    {

	$this->token = $this->get_token_value('BOOLFALSE');
    }
    function yy_r1_9($yy_subpatterns)
    {

	$this->token = $this->get_token_value('FLOAT');
    }
    function yy_r1_10($yy_subpatterns)
    {

	$this->token = $this->get_token_value('INTEGER');
    }
    function yy_r1_11($yy_subpatterns)
    {

	$this->token = $this->get_token_value('STRING');
    }
    function yy_r1_12($yy_subpatterns)
    {

	$this->token = $this->get_token_value('NAME');
    }
    function yy_r1_13($yy_subpatterns)
    {

	$this->token = $this->get_token_value('OTHER');
    }

	}
