<?php
	/**
	 * @package aCMS
	 */
	require_once(__DIR__ . '/' . "../AOF/AOFData.class.php");
	
	/**
	 * Class which defines the structure of a the `config.dat.php` file
	 */
	class ConfigurationConnection extends AOFData {
		protected $construct_args = array(
			'type',     'filepath', 'hostname', 'username',
			'password', 'database', 'table');
		
		
		
		/**
		 * Initialize this class with the global $CONFIG_* variables provided by
		 * the `config.dat.php` file
		 */
		public static function from_scope() {
			// Make global variables available
			global $CONFIG_TYPE;
			global $CONFIG_FILEPATH, $CONFIG_HOSTNAME, $CONFIG_USERNAME;
			global $CONFIG_PASSWORD, $CONFIG_DATABASE, $CONFIG_TABLE;
			
			// Initialize this class
			return new self($CONFIG_TYPE,     $CONFIG_FILEPATH,
			                $CONFIG_HOSTNAME, $CONFIG_USERNAME,
			                $CONFIG_PASSWORD, $CONFIG_DATABASE, $CONFIG_TABLE);
		}
	}
