<?php
	/**
	 * 
	 *
	 * @package aCMS
	 */
	require_once(__DIR__ . '/' . "AOFObject.class.php");
	/**
	 * Base class for all error templates
	 */
	abstract class AOFErrorTemplate extends AOFObject {}
	
	
	
	class AOFFileErrorTemplate extends AOFErrorTemplate {
		public function get_message($filepath, $mode) {
			// Find out if the mode requires any readability or writeability
			list($readable, $writeable) = $this->parse_mode($mode);
			
			// Check if the file is writeable if requested
			if($writeable && !is_writable($filepath)) {
				return "The %s file \"$filepath\" is not writable";
			}
			// Check if the file is readable if requested
			if($readable && !is_readable($filepath)) {
				return "The %s file \"$filepath\" is not readable";
			}
			// Check if the file exists
			if(!file_exists($filepath)) {
				return "The %s file \"$filepath\" does not exist";
			}
			
			return false;
		}
		
		
		public function get_solutions($filepath, $mode) {
			// Find out if the mode requires any readability or writeability
			list($readable, $writeable) = $this->parse_mode($mode);
			
			$solutions = array();
			// Check if file exists
			if(!file_exists($filepath)) {
				$solutions[] = "Create the file";
			}
			// Check if file is readable if requested
			if($readable && !is_readable($filepath)) {
				$solutions[] = "Make the file readable";
			}
			// Check if file is writeable if requested
			if($writeable && !is_writable($filepath)) {
				$solutions[] = "Make the file writable";
			}
			
			// Check for right specific issues
			if(!is_readable($filepath) || !is_writable($filepath)) {
				$solutions[] =
					"On how to make a file read- or writable consult your " .
					"server administrator or search in the manual of your " .
					"favourite file transmission program for the topics ".
					"\"chmod\" and \"file rights\".";
			}
			
			return $solutions;
		}
		
		
		public function parse_mode($mode) {
			if($mode == 'e') {
				$readable = false;
				$writable = false;
			} elseif($mode == 'r') {
				$readable = true;
				$writable = false;
			} elseif($mode == 'r+') {
				$readable = true;
				$writable = true;
			} elseif($mode == 'w') {
				$readable = false;
				$writable = true;
			} else {
				return array(false, false);
			}
			
			return array($readable, $writable);
		}
	}
